package com.androidbook.simplelivefolder;

import android.app.Activity;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.text.util.Linkify;
import android.widget.TextView;
import android.widget.Toast;

public class SimpleViewDetailsActivity extends Activity {
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.details);
        try {
            Intent launchIntent = getIntent();
            Uri launchData = launchIntent.getData();
            String id = launchData.getLastPathSegment();
            Uri dataDetails =
                Uri.withAppendedPath(SimpleFieldnotesContentProvider.CONTENT_URI,
                    id);
            Cursor cursor = managedQuery(dataDetails, null, null, null, null);
            cursor.moveToFirst();
            String fieldnoteTitle =
                cursor.getString(cursor
                    .getColumnIndex(SimpleFieldnotesContentProvider.FIELDNOTES_TITLE));
            String fieldnoteBody =
                cursor.getString(cursor
                    .getColumnIndex(SimpleFieldnotesContentProvider.FIELDNOTES_BODY));
            TextView fieldnoteTitleView = (TextView) findViewById(R.id.text_title);
            fieldnoteTitleView.setText(fieldnoteTitle);
            TextView fieldnoteBodyView = (TextView) findViewById(R.id.text_body);
            fieldnoteBodyView.setLinksClickable(true);
            fieldnoteBodyView.setAutoLinkMask(Linkify.ALL);
            fieldnoteBodyView.setText(fieldnoteBody);
            
        } catch (Exception e) {
            Toast.makeText(this, "Niepowodzenie.", Toast.LENGTH_LONG).show();
        }
    }
}
